% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PPPFunctionLink.R
\name{PPPFunctionLink}
\alias{PPPFunctionLink}
\title{PPPFunctionLink}
\description{
Base class to build link function pre-post processing class. See also
the PrePostProcessing documentation
}
\details{
This class is used to define pre/post processing class with a link function
and its inverse. See example.
}
\examples{
## Start with data
XY = SBCK::dataset_like_tas_pr(2000)
X0 = XY$X0
X1 = XY$X1
Y0 = XY$Y0

## Define the link function
transform  = function(x) { return(x^3) }
itransform = function(x) { return(x^(1/3)) }

## And the PPP method
ppp = PPPFunctionLink$new( bc_method = CDFt , transform = transform ,
                                             itransform = itransform )

## And now the correction
## Bias correction
ppp$fit(Y0,X0,X1)
Z = ppp$predict(X1,X0)

}
\section{Super class}{
\code{\link[SBCK:PrePostProcessing]{SBCK::PrePostProcessing}} -> \code{PPPFunctionLink}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PPPFunctionLink-new}{\code{PPPFunctionLink$new()}}
\item \href{#method-PPPFunctionLink-transform}{\code{PPPFunctionLink$transform()}}
\item \href{#method-PPPFunctionLink-itransform}{\code{PPPFunctionLink$itransform()}}
\item \href{#method-PPPFunctionLink-clone}{\code{PPPFunctionLink$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="fit"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-fit'><code>SBCK::PrePostProcessing$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="predict"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-predict'><code>SBCK::PrePostProcessing$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPFunctionLink-new"></a>}}
\if{latex}{\out{\hypertarget{method-PPPFunctionLink-new}{}}}
\subsection{Method \code{new()}}{
Create a new PPPFunctionLink object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPFunctionLink$new(transform_, itransform_, cols = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transform_}}{The transform function}

\item{\code{itransform_}}{The inverse transform function}

\item{\code{cols}}{Columns to apply the link function}

\item{\code{...}}{Others arguments are passed to PrePostProcessing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PPPFunctionLink` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPFunctionLink-transform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPFunctionLink-transform}{}}}
\subsection{Method \code{transform()}}{
Apply the transform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPFunctionLink$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Xt a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPFunctionLink-itransform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPFunctionLink-itransform}{}}}
\subsection{Method \code{itransform()}}{
Apply the inverse transform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPFunctionLink$itransform(Xt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xt}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
X a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPFunctionLink-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PPPFunctionLink-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPFunctionLink$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
