% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PPPDiffRef.R
\name{PPPDiffRef}
\alias{PPPDiffRef}
\title{PPPDiffRef}
\description{
Apply the diff w.r.t. a ref transformation.
}
\details{
Transform a dataset such that all `lower` dimensions are replaced by
the `ref` dimension minus the `lower`; and all `upper` dimensions are
replaced by `upper` minus `ref`.
}
\examples{
## Parameters
size  = 2000
nfeat = 5
sign  = base::sample( base::c(-1,1) , nfeat - 1 , replace = TRUE )

## Build data
X     = matrix( stats::rnorm( n = size ) , ncol = 1 )
for( s in sign )
{
	X = base::cbind( X , X[,1] + s * base::abs(matrix( stats::rnorm(n = size) , ncol = 1 )) )
}

## PPP
lower = which( sign ==  1 ) + 1
upper = which( sign == -1 ) + 1
ppp   = SBCK::PPPDiffRef$new( ref = 1 , lower = lower , upper = upper )
Xt    = ppp$transform(X)
Xti   = ppp$itransform(Xt)

print( base::max( base::abs( X - Xti ) ) )

}
\section{Super class}{
\code{\link[SBCK:PrePostProcessing]{SBCK::PrePostProcessing}} -> \code{PPPDiffRef}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ref}}{[integer] The reference column}

\item{\code{lower}}{[vector integer] Dimensions lower than ref}

\item{\code{upper}}{[vector integer] Dimensions upper than ref}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PPPDiffRef-new}{\code{PPPDiffRef$new()}}
\item \href{#method-PPPDiffRef-transform}{\code{PPPDiffRef$transform()}}
\item \href{#method-PPPDiffRef-itransform}{\code{PPPDiffRef$itransform()}}
\item \href{#method-PPPDiffRef-clone}{\code{PPPDiffRef$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="fit"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-fit'><code>SBCK::PrePostProcessing$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="predict"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-predict'><code>SBCK::PrePostProcessing$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPDiffRef-new"></a>}}
\if{latex}{\out{\hypertarget{method-PPPDiffRef-new}{}}}
\subsection{Method \code{new()}}{
Create a new PPPDiffRef object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPDiffRef$new(ref, lower = NULL, upper = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ref}}{The reference column}

\item{\code{lower}}{Dimensions lower than ref}

\item{\code{upper}}{Dimensions upper than ref}

\item{\code{...}}{Others arguments are passed to PrePostProcessing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PPPDiffRef` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPDiffRef-transform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPDiffRef-transform}{}}}
\subsection{Method \code{transform()}}{
Apply the DiffRef transform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPDiffRef$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Xt a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPDiffRef-itransform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPDiffRef-itransform}{}}}
\subsection{Method \code{itransform()}}{
Apply the DiffRef inverse transform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPDiffRef$itransform(Xt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xt}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
X a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPDiffRef-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PPPDiffRef-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPDiffRef$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
