% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.AR2D2.R
\name{AR2D2}
\alias{AR2D2}
\title{AR2D2 (Analogues Rank Resampling for Distributions and Dependences) method}
\description{
Perform a multivariate (non stationary) bias correction.
}
\details{
Use Quantiles shuffle in calibration and projection period with CDFt
}
\examples{

## Three 4-variate random variables
Y0 = matrix( stats::rnorm( n = 1000 ) , ncol = 4 ) ## Biased in calibration period
X0 = matrix( stats::rnorm( n = 1000 ) , ncol = 4 ) / 2 + 3 ## Reference in calibration period
X1 = matrix( stats::rnorm( n = 1000 ) , ncol = 4 ) * 2 + 6 ## Biased in projection period

## Bias correction
cond_col = base::c(2,4)
lag_search = 6
lag_keep = 3
## Step 1 : construction of the class AR2D2 
ar2d2 = SBCK::AR2D2$new( cond_col , lag_search , lag_keep ) 
## Step 2 : Fit the bias correction model
ar2d2$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction
Z = ar2d2$predict(X1,X0) 

}
\references{
Vrac, M. et S. Thao (2020). “R2 D2 v2.0 : accounting for temporal
            dependences in multivariate bias correction via analogue rank
            resampling”. In : Geosci. Model Dev. 13.11, p. 5367-5387.
            doi :10.5194/gmd-13-5367-2020.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mvq}}{[MVQuantilesShuffle] Class to transform dependance structure}

\item{\code{bc_method}}{[SBCK::] Bias correction method}

\item{\code{bckwargs}}{[list] List of arguments of bias correction}

\item{\code{bcm_}}{[SBCK::] Instancied bias correction method}

\item{\code{reverse}}{[bool] If we apply bc_method first and then shuffle, or reverse}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AR2D2-new}{\code{AR2D2$new()}}
\item \href{#method-AR2D2-fit}{\code{AR2D2$fit()}}
\item \href{#method-AR2D2-predict}{\code{AR2D2$predict()}}
\item \href{#method-AR2D2-clone}{\code{AR2D2$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AR2D2-new"></a>}}
\if{latex}{\out{\hypertarget{method-AR2D2-new}{}}}
\subsection{Method \code{new()}}{
Create a new AR2D2 object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AR2D2$new(
  col_cond = base::c(1),
  lag_search = 1,
  lag_keep = 1,
  bc_method = SBCK::CDFt,
  shuffle = "quantile",
  reverse = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col_cond}}{Conditionning colum}

\item{\code{lag_search}}{Number of lags to transform the dependence structure}

\item{\code{lag_keep}}{Number of lags to keep}

\item{\code{bc_method}}{Bias correction method}

\item{\code{shuffle}}{Shuffle method used, can be quantile or rank}

\item{\code{reverse}}{If we apply bc_method first and then shuffle, or reverse}

\item{\code{...}}{Others named arguments passed to bc_method$new}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `AR2D2` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AR2D2-fit"></a>}}
\if{latex}{\out{\hypertarget{method-AR2D2-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method. If X1 is NULL, the method is considered
as stationary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AR2D2$fit(Y0, X0, X1 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AR2D2-predict"></a>}}
\if{latex}{\out{\hypertarget{method-AR2D2-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AR2D2$predict(X1 = NULL, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features or NULL] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL (and vice-versa), else return a list
                         containing Z1 and Z0, the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AR2D2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AR2D2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AR2D2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
