% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{combine_data}
\alias{combine_data}
\title{Combines different effect sizes into a common metric}
\usage{
combine_data(
  d = NULL,
  r = NULL,
  z = NULL,
  logOR = NULL,
  OR = NULL,
  t = NULL,
  y = NULL,
  se = NULL,
  v = NULL,
  n = NULL,
  lCI = NULL,
  uCI = NULL,
  study_names = NULL,
  study_ids = NULL,
  weight = NULL,
  data = NULL,
  transformation = "fishers_z",
  return_all = FALSE,
  ...
)
}
\arguments{
\item{d}{a vector of effect sizes measured as Cohen's d}

\item{r}{a vector of effect sizes measured as correlations}

\item{z}{a vector of effect sizes measured as Fisher's z}

\item{logOR}{a vector of effect sizes measured as log odds ratios}

\item{OR}{a vector of effect sizes measured as odds ratios}

\item{t}{a vector of t/z-statistics}

\item{y}{a vector of unspecified effect sizes (note that effect size
transformations are unavailable with this type of input)}

\item{se}{a vector of standard errors of the effect sizes}

\item{v}{a vector of variances of the effect sizes}

\item{n}{a vector of overall sample sizes}

\item{lCI}{a vector of lower bounds of confidence intervals}

\item{uCI}{a vector of upper bounds of confidence intervals}

\item{study_names}{an optional argument with the names of the studies}

\item{study_ids}{an optional argument specifying dependency between the
studies (for using a multilevel model). Defaults to \code{NULL} for
studies being independent.}

\item{weight}{specifies likelihood weights of the individual estimates.
Notes that this is an untested experimental feature.}

\item{data}{a data frame with column names corresponding to the
variable names used to supply data individually}

\item{transformation}{transformation to be applied to the supplied
effect sizes before fitting the individual models. Defaults to
\code{"fishers_z"}. We highly recommend using \code{"fishers_z"}
transformation since it is the only variance stabilizing measure
and does not bias PET and PEESE style models. The other options are
\code{"cohens_d"}, correlation coefficient \code{"r"} and \code{"logOR"}.
Supplying \code{"none"} will treat the effect sizes as unstandardized and
refrain from any transformations.}

\item{return_all}{whether data frame containing all filled values should be
returned. Defaults to \code{FALSE}}

\item{...}{additional arguments.}
}
\value{
\code{combine_data} returns a data.frame.
}
\description{
\code{combine_data} combines different effect sizes
into a common measure specified in \code{transformation}. Either
a data.frame \code{data} with columns named corresponding to the
arguments or vectors with individual values can be passed.
}
\details{
The aim of the function is to combine different, already calculated,
effect size measures. In order to obtain effect size measures from raw values,
e.g, mean differences, standard deviations, and sample sizes, use
\link[metafor]{escalc} function.

The function checks the input values and in transforming the input into a common
effect size measure in the following fashion:
\enumerate{
\item obtains missing standard errors by squaring variances
\item obtains missing standard errors from confidence intervals (after transformation to
Fisher's z scale for \code{d} and \code{r}).
\item obtains missing sample sizes (or standard errors for logOR) from t-statistics
and effect sizes
\item obtains missing standard errors from sample sizes and effect sizes
\item obtains missing sample sizes from standard errors and effect sizes
\item obtains missing t-statistics from sample sizes and effect sizes
(or standard errors and effect sizes for logOR)
\item changes the effect sizes direction to be positive
\item transforms effect sizes into the common effect size
\item transforms standard errors into the common metric
}

If the \code{transforms} is \code{NULL} or an unstandardized effect size \code{y} is
supplied, steps 4-9 are skipped.
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=check_setup]{check_setup()}}, \code{\link[=effect_sizes]{effect_sizes()}}, \code{\link[=standard_errors]{standard_errors()}}, and \code{\link[=sample_sizes]{sample_sizes()}}
}
