% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Preparing Data}
\usage{
prepare_data(df, HighertheBetter = 0)
}
\arguments{
\item{df}{a \code{n} by \code{p} matrix or dataframe of scores of \code{n}
objects given by \code{p} judges. Each column corresponds to a different judge.}

\item{HighertheBetter}{an integer with 1 indicating that the higher values in the
input correspond to the better rank. An optional parameter. Default value is 0,
i.e., the lower the score the better the rank (e.g., score of 1 is the topmost rank).}
}
\value{
A list containing a matrix of input rankings (named \code{input_rkgs}) and a
weight vector corresponding to weights for each judge (named \code{wt}). These
two objects are used as inputs to \code{\link{subit_convergence}},
\code{\link{rap_greedy_alg}}, \code{\link{fur}}, and \code{\link{sigfur}}.
}
\description{
Prepares the given data for rank aggregation functions. The function
returns a matrix of input rankings and a vector indicating weights of the
ranking for each judge. Useful when scores need to be converted to rankings.
Also helpful in reducing the size of the problem for large \code{p}, especially
when \code{p} > \code{n}!.
}
\examples{
## Five input rankings with five objects 
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 
                       2, 4, 5, 3),byrow = FALSE, ncol = 5)
out = prepare_data(input_rkgs) 
input_rkgs = out$input_rkgs
wt = out$wt

## Five input rankings with five objects
## testing the higher the better 
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 
                       2, 4, 5, 3),byrow = FALSE, ncol = 5)
input_rkgs = input_rkgs*2+input_rkgs #artificially create a score matrix
# Testing the higher the better rank
out = prepare_data(input_rkgs, HighertheBetter = 1) 
input_rkgs = out$input_rkgs
wt = out$wt

}
\seealso{
\code{\link{subit_convergence}}, \code{\link{rap_greedy_alg}}, \code{\link{fur}}, \code{\link{sigfur}}
}
