% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{\%~\%}
\alias{\%~\%}
\title{Distributional assignment operator}
\usage{
x \%~\% distr
}
\arguments{
\item{x}{LHS; Random effect or data for which distribution assignment applies}

\item{distr}{RHS; Distribution expression}
}
\value{
The updated value of the hidden variable \code{.nll}.
}
\description{
Distributional assignment operator
}
\details{
Provides a slightly simplified syntax \emph{inspired by}, but \emph{not} compatible with, other probabilistic programming languages (e.g. BUGS/JAGS):
\itemize{
\item \code{x \%~\% distribution(...)} is syntactic sugar for \code{.nll <- .nll - sum(distribution(x,...,log=TRUE))}
\item The variable \code{.nll} is automatically initialized to \code{0} and returned on exit.
}
}
\note{
If the shorter name \code{~} is preferred, it can be locally overloaded using \code{"~" <- RTMB::"\%~\%"}.
}
\examples{
f <- function(parms) {
  getAll(parms)
  x \%~\% dnorm(mu, 1)
  y \%~\% dpois(exp(x))
}
p <- list(mu=0, x=numeric(10))
y <- 1:10
obj <- MakeADFun(f, p, random="x")
}
