% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/methods.R
\name{ADmatrix}
\alias{ADmatrix}
\alias{t.adsparse}
\alias{[.adsparse}
\alias{[<-.adsparse}
\alias{diag,adsparse,missing,missing-method}
\alias{expm,advector-method}
\alias{expm,adsparse-method}
\alias{dim,adsparse-method}
\alias{\%*\%,anysparse,ad-method}
\alias{\%*\%,ad,anysparse-method}
\alias{\%*\%,adsparse,adsparse-method}
\alias{\%*\%,ad,ad-method}
\alias{tcrossprod,advector,ANY-method}
\alias{crossprod,advector,ANY-method}
\alias{solve,ad,ad.-method}
\alias{solve,num,num.-method}
\alias{solve,anysparse,ad.-method}
\alias{colSums,advector-method}
\alias{rowSums,advector-method}
\alias{cbind.advector}
\alias{rbind.advector}
\title{AD matrix methods (sparse and dense)}
\usage{
\method{t}{adsparse}(x)

\method{[}{adsparse}(x, ...)

\method{[}{adsparse}(x, ...) <- value

\S4method{diag}{adsparse,missing,missing}(x)

\S4method{expm}{advector}(x)

\S4method{expm}{adsparse}(x)

\S4method{dim}{adsparse}(x)

\S4method{\%*\%}{anysparse,ad}(x, y)

\S4method{\%*\%}{ad,anysparse}(x, y)

\S4method{\%*\%}{adsparse,adsparse}(x, y)

\S4method{\%*\%}{ad,ad}(x, y)

\S4method{tcrossprod}{advector,ANY}(x, y = NULL)

\S4method{crossprod}{advector,ANY}(x, y = NULL)

\S4method{solve}{ad,ad.}(a, b)

\S4method{solve}{num,num.}(a, b)

\S4method{solve}{anysparse,ad.}(a, b)

\S4method{colSums}{advector}(x)

\S4method{rowSums}{advector}(x)

\method{cbind}{advector}(...)

\method{rbind}{advector}(...)
}
\arguments{
\item{x}{matrix (sparse or dense)}

\item{...}{As \link[base]{cbind}}

\item{value}{Replacement value}

\item{y}{matrix (sparse or dense)}

\item{a}{matrix}

\item{b}{matrix, vector or missing}
}
\value{
Object of class \code{advector} with a dimension attribute for dense matrix operations; Object of class \code{adsparse} for sparse matrix operations.
}
\description{
Matrices (\strong{base} package) and sparse matrices (\strong{Matrix} package) can be used inside the \code{RTMB} objective function as part of the calculations. Behind the scenes these R objects are converted to AD representations when needed. AD objects have a temporary lifetime, so you probably won't see them / need to know them. The only important thing is which \emph{methods} work for the objects.
}
\section{Functions}{
\itemize{
\item \code{t(adsparse)}: AD sparse matrix transpose. Re-directs to \link[Matrix]{t,CsparseMatrix-method}.

\item \code{[}: AD sparse matrix subsetting. Re-directs to \link[Matrix]{[-methods}.

\item \code{`[`(adsparse) <- value}: AD sparse matrix subset assignment. Re-directs to \link[Matrix]{[<--methods}.

\item \code{diag(x = adsparse, nrow = missing, ncol = missing)}: AD sparse matrix diagonal extract. Re-directs to \link[Matrix]{diag,CsparseMatrix-method}.

\item \code{expm(advector)}: AD matrix exponential

\item \code{expm(adsparse)}: AD matrix exponential

\item \code{dim(adsparse)}: AD sparse matrix dimension

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{tcrossprod(x = advector, y = ANY)}: AD matrix multiply

\item \code{crossprod(x = advector, y = ANY)}: AD matrix multiply

\item \code{solve(a = ad, b = ad.)}: AD matrix inversion and solve

\item \code{solve(a = num, b = num.)}: AD matrix inversion and solve

\item \code{solve(a = anysparse, b = ad.)}: Sparse AD matrix solve (not yet implemented)

\item \code{colSums(advector)}: AD matrix (or array) colsums

\item \code{rowSums(advector)}: AD matrix (or array) rowsums

\item \code{cbind(advector)}: AD matrix column bind

\item \code{rbind(advector)}: AD matrix row bind

}}
\examples{
F <- MakeTape(function(x) matrix(1:9,3,3) \%*\% x, numeric(3))
F$jacobian(1:3)
F <- MakeTape(function(x) Matrix::expm(matrix(x,2,2)), numeric(4))
F$jacobian(1:4)
}
