% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.rv_mixture.R
\name{rv_mixture}
\alias{rv_mixture}
\title{rv_mixture}
\description{
rv_mixture distribution in OOP way.
}
\details{
No fit allowed.
}
\examples{
## Define the mixture
l_dist  = list( Exponential$new() , Normal$new( mean = 5 , sd = 1 ) )
weights = base::c( 0.2 , 0.8 )
rvX = rv_mixture$new( l_dist , weights )

## Draw samples
X   = rvX$rvs( 1000 )

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{l_dist}}{[list]    List of distributions.}

\item{\code{n_dist}}{[integer] Numbers of distribution.}

\item{\code{weights}}{[vector]  Weights of the distributions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-rv_mixture-new}{\code{rv_mixture$new()}}
\item \href{#method-rv_mixture-rvs}{\code{rv_mixture$rvs()}}
\item \href{#method-rv_mixture-density}{\code{rv_mixture$density()}}
\item \href{#method-rv_mixture-logdensity}{\code{rv_mixture$logdensity()}}
\item \href{#method-rv_mixture-cdf}{\code{rv_mixture$cdf()}}
\item \href{#method-rv_mixture-icdf}{\code{rv_mixture$icdf()}}
\item \href{#method-rv_mixture-sf}{\code{rv_mixture$sf()}}
\item \href{#method-rv_mixture-isf}{\code{rv_mixture$isf()}}
\item \href{#method-rv_mixture-clone}{\code{rv_mixture$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-new"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-new}{}}}
\subsection{Method \code{new()}}{
Create a new rv_mixture object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$new(l_dist, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{l_dist}}{[list]    List of ROOPSD distributions.}

\item{\code{weights}}{[vector]  Weights of the distributions. If NULL,
1 / length(l_dist) is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `rv_mixture` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-density"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-density}{}}}
\subsection{Method \code{density()}}{
Density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$density(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-logdensity}{}}}
\subsection{Method \code{logdensity()}}{
Log density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$logdensity(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the log-density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the log density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-sf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-isf"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rv_mixture-clone"></a>}}
\if{latex}{\out{\hypertarget{method-rv_mixture-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
