% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rfcca.R
\name{print.rfcca}
\alias{print.rfcca}
\title{Print summary output of a RFCCA analysis}
\usage{
\method{print}{rfcca}(x, ...)
}
\arguments{
\item{x}{An object of class \code{(rfcca,grow)}, \code{(rfcca,predict)} or
\code{(rfcca,globalsignificance)}.}

\item{...}{Optional arguments to be passed to other methods.}
}
\description{
Print summary output of a RFCCA analysis. This is the default print method
for the package.
}
\examples{
\donttest{
## load generated example data
data(data, package = "RFCCA")
set.seed(2345)

## train rfcca
rfcca.obj <- rfcca(X = data$X, Y = data$Y, Z = data$Z, ntree = 100,
  importance = TRUE)

## print the grow object
print(rfcca.obj)
}
}
