% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{split_noun_pp}
\alias{split_noun_pp}
\title{Split row and column labels into nouns and prepositional phrases}
\usage{
split_noun_pp(
  labels,
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = FALSE,
  prepositions = RCLabels::prepositions_list
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{x}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{The notation type to be used when extracting prepositions.
Default is \code{RCLabels::notations_list}, meaning that
the notation is inferred using \code{infer_notation()}.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \code{RCLabels::notations_list},
the default value of \code{FALSE} means that
\code{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\code{RCLabels::from_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions_list}.}
}
\value{
A list of lists with items named \code{noun} and \code{pp}.
}
\description{
This function is similar to \code{split_pref_suff()} in that it returns a list.
However, this function's list is more detailed than
\code{split_pref_suff()}.
The return value from this function is a list
with the first named item being the prefix (with the name \code{noun})
followed by objects of prepositional phrases
(with names being prepositions that precede the objects).
}
\details{
Unlike \code{split_pref_suff()}, it does not make sense to have a \code{transpose}
argument on \code{split_noun_pp()}.
Labels may not have the same structure,
e.g., they may have different prepositions.
}
\examples{
# Specify the notation
split_noun_pp(c("a [of b in c]", "d [of e into f]"),
              notation = bracket_notation)
# Infer the notation via default arguments
split_noun_pp(c("a [of b in c]", "d [of e into f]"))
}
