% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RStack.R
\docType{data}
\name{RStack}
\alias{RStack}
\title{The RStack reference class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RStack
}
\description{
The RStack reference class implements the data structure stack.
}
\details{
A stack is an ordered list of elements following the Last-In-First-Out (LIFO) principle.
The \code{push} method takes elements and add them to the top position (right) of the stack,
while the \code{pop} method returns and removes the last "pushed" (top or rightmost) element in the stack.

The elements in the stack are not necessarily to be of the same type,
and they can be any R objects.
}
\section{References}{

For the details about the stack data structure, see \href{https://en.wikipedia.org/wiki/Stack_(abstract_data_type)}{Stack at Wikipedia}.
}

\section{Immutable Methods}{


The immutable method does not change the instance.

\describe{

\item{\code{peek()}}{
This method returns the last pushed (top or rightmost) element in the stack.
It returns \code{NULL} if the stack is empty.
}

}
}

\section{Mutable Methods}{


The mutable methods change the instance.

\describe{

\item{\code{push(..., collapse=NULL)}}{
The \code{push} method pushes the elements in \code{...} and \code{collapse} into the stack
(to the top or right).

Note that you can input multiple elements.
}

\item{\code{pop()}}{
The \code{pop} method pops (returns and removes) the last pushed (rightmost) element in the stack.
It returns \code{NULL} if the stack is empty.
}

}
}

\examples{

### create a new instance

# to create a new instance of the class
stack <- RStack$new()

# the previous RStack instance will be removed if you run
stack <- RStack$new(0, 1, 2, collapse=list(3, 4))
# the following sentence is equivalent to the above
stack <- RStack$new(0, 1, 2, 3, 4)
# where the numbers 0, 1, 2, 3, 4 are pushed into the stack

### push elements

# it can be one single element
stack$push(5)
# it can be several elements separated by commas
# note the whole list will be one element of the stack
# because it is not passed through the collapse argument
stack$push(list(a=10,b=20), "Hello world!")
# the collapse argument takes a list whose elements will be collapsed
# but the elements' names will not be saved
stack$push(collapse = list(x=100,y=200))
# they can be used together
stack$push("hurrah", collapse = list("RStack",300))

### pop an element

# pop only one element at a time
val <- stack$pop()
# then we keep poping!
while(!is.null(val)) val <- stack$pop()

}
\seealso{
\link{R6DS} for the introduction of the reference class and some common methods
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{RStack}
