% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{EllipseEquationFromFivePoints}
\alias{EllipseEquationFromFivePoints}
\title{Ellipse equation from five points}
\usage{
EllipseEquationFromFivePoints(P1, P2, P3, P4, P5)
}
\arguments{
\item{P1, P2, P3, P4, P5}{the five points}
}
\value{
A named numeric vector.
}
\description{
The coefficients of the implicit equation of an ellipse from
five points on this ellipse.
}
\details{
The implicit equation of the ellipse is
\code{Ax² + Bxy + Cy² + Dx + Ey + F = 0}. This function returns
A, B, C, D, E and F.
}
\examples{
ell <- Ellipse$new(c(2,3), 5, 4, 30)
set.seed(666)
pts <- ell$randomPoints(5, "on")
cf1 <- EllipseEquationFromFivePoints(pts[1,],pts[2,],pts[3,],pts[4,],pts[5,])
cf2 <- ell$equation() # should be the same up to a multiplicative factor
all.equal(cf1/cf1["F"], cf2/cf2["F"])
}
