% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tamhaneDunnettTest.R
\name{tamhaneDunnettTest}
\alias{tamhaneDunnettTest}
\alias{tamhaneDunnettTest.default}
\alias{tamhaneDunnettTest.formula}
\alias{tamhaneDunnettTest.aov}
\title{Tamhane-Dunnett Many-to-One Comparison Test}
\usage{
tamhaneDunnettTest(x, ...)

\method{tamhaneDunnettTest}{default}(x, g, alternative = c("two.sided", "greater", "less"), ...)

\method{tamhaneDunnettTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  ...
)

\method{tamhaneDunnettTest}{aov}(x, alternative = c("two.sided", "greater", "less"), ...)
}
\arguments{
\item{x}{a numeric vector of data values, a list of numeric data
vectors or a fitted model object, usually an \link[stats]{aov} fit.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis.
Defaults to \code{"two.sided"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Tamhane-Dunnett's multiple comparisons test with one control.
For many-to-one comparisons in an one-factorial layout
with normally distributed residuals and unequal variances
Tamhane-Dunnett's test can be used.
Let \eqn{X_{0j}} denote a continuous random variable
with the \eqn{j}-the realization of the control group
(\eqn{1 \le j \le n_0}) and \eqn{X_{ij}} the \eqn{j}-the realization
in the \eqn{i}-th treatment group (\eqn{1 \le i \le k}).
Furthermore, the total sample size is \eqn{N = n_0 + \sum_{i=1}^k n_i}.
A total of \eqn{m = k} hypotheses can be tested: The null hypothesis is
H\eqn{_{i}: \mu_i = \mu_0} is tested against the alternative
A\eqn{_{i}: \mu_i \ne \mu_0} (two-tailed). Tamhane-Dunnett's test
statistics are given by

\deqn{
 t_{i} \frac{\bar{X}_i - \bar{X_0}}
 {\left( s^2_0 / n_0 + s^2_i / n_i \right)^{1/2} } ~~
 (1 \le i \le k)
}{%
 SEE PDF
}

The null hypothesis is rejected if
\eqn{|t_{i}| > T_{kv_{i}\rho_{ij}\alpha}} (two-tailed),
with

\deqn{
 v_i = n_0 + n_i - 2
}{%
 SEE PDF
}

degree of freedom and the correlation

\deqn{
 \rho_{ii} = 1, ~ \rho_{ij} = 0 ~ (i \ne j).
}{%
 SEE PDF
}

The p-values are computed from the multivariate-t
distribution as implemented in the function
\code{\link[mvtnorm]{pmvt}} distribution.
}
\examples{
set.seed(245)
mn <- c(1, 2, 2^2, 2^3, 2^4)
x <- rep(mn, each=5) + rnorm(25)
g <- factor(rep(1:5, each=5))

fit <- aov(x ~ g - 1)
shapiro.test(residuals(fit))
bartlett.test(x ~ g - 1)
anova(fit)
## works with object of class aov
summary(tamhaneDunnettTest(fit, alternative = "greater"))

}
\references{
OECD (ed. 2006) \emph{Current approaches in the statistical analysis
of ecotoxicity data: A guidance to application - Annexes}. OECD Series
on testing and assessment, No. 54.
}
\seealso{
\code{\link[mvtnorm]{pmvt}}, \code{\link{welchManyOneTTest}}
}
\concept{parametric}
\keyword{htest}
