% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Categoric.R
\name{sim.categoric}
\alias{sim.categoric}
\title{This function simulates (generates) categorical data sets by a given Confirmatory Factor Analysis model.}
\usage{
sim.categoric(
  nd = 10,
  ss = 100,
  fcors,
  loading,
  f.loc,
  threshold,
  cont = "FALSE"
)
}
\arguments{
\item{nd}{Number of the data set, an integer.}

\item{ss}{Sample Size, an integer and larger than 10.}

\item{fcors}{The factor correlation matrix, a symmetric matrix. If one-factor model is used this should be matrix(1,1,1).}

\item{loading}{The factor loading matrix. The column represents factors and non-zero rows represent the number of items under each factor.}

\item{f.loc}{File location. Generated data sets will be saved at the user-defined location.}

\item{threshold}{The threshold values.}

\item{cont}{TRUE or FALSE: Indicating whether original continuous data will be saved or not.}
}
\description{
Based on a given Confirmatory Factor Analysis model, this function simulates data sets.
In each data file, the first column shows sample numbers. The second and other columns show actual simulated data sets for each item.
If the model has 2 factors and each factor has 3 items, for example, column names will be something like "ID, F1_x1, F1_x2, F1_x3, F2_x1, F2_x2, F2_x3".
On the other hand, the number of rows shows the sample number of the data. Besides, there will be two more files saved in the folder.
First of them is "Model_Info.dat". This file includes factor correlation and factor loading matrices.
The second is "Data_List.dat". The file contains the names of the data sets which were generated.
}
\examples{
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
tres<-c(-Inf, -1.645, -.643, .643, 1.645, Inf) # five categories

sim.categoric(nd=100,ss=100, fcors=fc,loading=fl, f.loc=tempdir(), threshold = tres)
}
\author{
Fatih Orçan
}
