% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/someMeshes.R
\name{cyclideMesh}
\alias{cyclideMesh}
\title{Cyclide mesh}
\usage{
cyclideMesh(a, c, mu, nu = 90L, nv = 40L)
}
\arguments{
\item{a, c, mu}{cyclide parameters, positive numbers such that
\code{c < mu < a}}

\item{nu, nv}{numbers of subdivisions, integers (at least 3)}
}
\value{
A triangle \strong{rgl} mesh (class \code{mesh3d}).
}
\description{
Triangle mesh of a Dupin cyclide.
}
\details{
The Dupin cyclide in the plane \emph{z=0}:
\if{html}{
  \figure{cyclide.png}{options: style="max-width:75\%;" alt="cyclide"}
}
\if{latex}{
  \out{\begin{center}}\figure{cyclide.png}\out{\end{center}}
}
}
\examples{
library(MeshesTools)
library(rgl)
mesh <- cyclideMesh(a = 97, c = 32, mu = 57)
sphere <- sphereMesh(x = 32, y = 0, z = 0, r = 40)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "chartreuse")
wire3d(mesh)
shade3d(sphere, color = "red")
wire3d(sphere)
}
