% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSums2.R
\name{rowSums2}
\alias{rowSums2}
\alias{rowSums2,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowSums2,ANY-method}
\alias{colSums2}
\alias{colSums2,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colSums2,ANY-method}
\title{Calculates the sum for each row (column) of a matrix-like object}
\usage{
rowSums2(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{rowSums2}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{rowSums2}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

colSums2(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{colSums2}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{colSums2}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the sum for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowSums2}} /
\code{matrixStats::\link[matrixStats]{colSums2}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowSums2(mat)
colSums2(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowSums2}()} and
\code{matrixStats::\link[matrixStats:rowSums2]{colSums2}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item \code{base::\link{sum}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
