% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findLocalMaxWinSize.R
\name{findLocalMaxWinSize}
\alias{findLocalMaxWinSize}
\title{Find local maxima and return the size of the window where they are maximum.}
\usage{
findLocalMaxWinSize(x, capWinSize = NA)
}
\arguments{
\item{x}{A numeric vector.}

\item{capWinSize}{the maximum window size to report. \code{NA} means unlimited.}
}
\value{
An integer vector \code{y} of the same length as \code{x}. \code{y[i]} will be the
size of the largest window on \code{x} containing \code{x[i]} where:
\itemize{
\item \code{x[i]} is a local maximum or a center of a plateau
\item \code{x[i]} is not at a window border
Optionally, if \code{capWinSize} is a positive integer, the maximum window size
is capped to that value, to increase performance. Use this in case you just
want to check if there exists a window of that size.
@export
@examples
x <- c(1, 2, 3, 2, 1)
findLocalMaxWinSize(x)
}
}
\description{
Compared to the rest of the package, this is a rather experimental function.
If you plan to use it or are interested in it, please open an issue at
https://github.com/zeehio/MassSpecWavelet/issues to show your interest.
}
