% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esti_polychoric.R
\name{esti_polychoric}
\alias{esti_polychoric}
\title{Polychoric Correlation}
\usage{
esti_polychoric(X, maxn = 100, e = 1e-08, ct = FALSE)
}
\arguments{
\item{X}{a matrix(2*N) or dataframe contains two polychoric variable, or a contingency table with both columns and rows names.}

\item{maxn}{the maximum iterations times.}

\item{e}{the maximum tolerance of convergence.}

\item{ct}{\code{TRUE} for contingency table, \code{FALSE} for matrix or dataframe}
}
\value{
\item{rho}{estimated value of polychoric correlation coefficient.}

\item{std}{standard deviation of rho.}

\item{iter}{times of iteration convergence.}

\item{Ex,Ey}{the support points series of regression model}
}
\description{
Estimate the polychoric correlation coefficient.
}
\examples{
X = gen_polychoric(1000,0.5,0:1,-1:0)
result = esti_polychoric(X)
print(c(result$rho,result$std,result$iter))
}
\references{
Zhang, P., Liu, B., & Pan, J. (2024). Iteratively Reweighted Least Squares Method for Estimating Polyserial and Polychoric Correlation Coefficients. Journal of Computational and Graphical Statistics, 33(1), 316–328. https://doi.org/10.1080/10618600.2023.2257251
}
\seealso{
\link{esti_polyserial}
}
