% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FI_sim.R
\name{FI.sim}
\alias{FI.sim}
\title{Simulate multivariate fractional white noise.}
\usage{
FI.sim(T, q, rho, d, B = diag(q), var = 1, burnin = 250)
}
\arguments{
\item{T}{positive integer determining the length of the simulated series.}

\item{q}{positive integer determining the dimension of the simulated series.}

\item{rho}{real value between 0 and 1 that determines correlation between the innovations.}

\item{d}{vector of memory parameters with length q.}

\item{B}{qxq matrix specifying cointegrating relations. By default \code{diag(q)}.}

\item{var}{positive real value that determines the variance of the innovations.
Default value is \code{var=1}.}

\item{burnin}{positive integer determining the length of the burnin period. 
Default is \code{burnin=250}.}
}
\description{
\code{FI.sim} Simulates a
}
\examples{
T=1000
series<-FI.sim(T=T,q=2,rho=0.7,d=c(0.4,0.4))
ts.plot(series, col=1:2)
cor(series)

series<-FI.sim(T=T,q=2,rho=0,d=c(0.1,0.4), B=rbind(c(1,-1),c(0,1)))
ts.plot(series, col=1:2)
}
