% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_diag.R
\name{ts.diag}
\alias{ts.diag}
\title{Diagnostic Plots for Time Series fits}
\usage{
ts.diag(x, lag = 10, band = qnorm(0.975)/sqrt(length(x)))
}
\arguments{
\item{x}{(type: numeric) residuals of the fitted time series model.}

\item{lag}{(type: numeric) maximum lag at which to calculate the acf and
Ljung-Box test. By default set to 10.}

\item{band}{(type: numeric) absolute value for bandwidth in the the ACF plot.
By default set to `qnorm(0.975)/sqrt(n)` which approximates to 0.07 for 
malleco data (n = 734)}
}
\value{
A ggplot object.
}
\description{
Plot time-series diagnostics.
}
\details{
This function plot the residuals, the autocorrelation function of the
residuals (ACF) and the p-values of the Ljung-Box Test for all lags up to
\code{lag}.
}
\examples{
ts.diag(malleco)
}
\seealso{
\code{\link{Box.Ljung.Test}}
}
