% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{ts_hdchange}
\alias{ts_hdchange}
\title{'no_nbd' or 'nbd' object construction}
\usage{
ts_hdchange(
  data,
  window_size = 30,
  m = 8,
  h = 1,
  N_rep = 999,
  alpha = 1e-05,
  quantiles = c(0.01, 0.05, 0.1),
  nbd_info = NULL
)
}
\arguments{
\item{data}{p by n data matrix, n = number of time series observations,
p = cross-sectional dimension.}

\item{window_size}{\eqn{window\_size = b \times n}, e.g. \eqn{n=100}, \eqn{b=30}.}

\item{m}{Number of blocks in long-run variance estimation, 8 by default.}

\item{h}{Parameter in long-run variance estimation, 1 by default.}

\item{N_rep}{Number of repetitions in MC simulation.}

\item{alpha}{A small positive number controlling for the threshold in break estimation.}

\item{quantiles}{An array of quantiles for critical values.}

\item{nbd_info}{A list containing the neighbourhood information, NULL by default
indicating no neighbourhoods.}
}
\value{
The return value is an S3 object of class 'no_nbd' or 'nbd'.
It contains a list of the following items:
\itemize{

\item data, m, h, N_rep, alpha, quantiles, and nbd_info are the same as in
the arguments.

\item n = number of time series observations.

\item p = cross-sectional dimension.

\item b = bandwith parameter \eqn{b = window\_size/n}.

}
}
\description{
This function creates an S3 object of class 'no_nbd' or 'nbd' containing the
initialising information supplied to the main function \code{\link[=hdchange]{hdchange()}}.
'no_nbd' or 'nbd' are constructed depending on whether the
neighbourhood information is provided. The resulting object will be used in the
test and estimation functions.
}
\details{
'nbd_info' indicates the location of individuals in the data matrix.
For example, 'nbd_info = list(c(1:10), c(25:35), c(7:18))' means that
there are three neighbourhoods. The first neighbourhood contains from the 1st
to 10th individuals and the same rule applies to the rest of neighbourhoods.
The neighbourhoods are allowed to be overlapped. See also the illustrating
example in \code{\link[=hdchange]{hdchange()}}.
}
\examples{
data <- covid_data

# No neighbourhood case
ts_no_nbd <- ts_hdchange(data,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

# Neighbourhood case
ts_nbd <- ts_hdchange(data,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1),
nbd_info = list(c(1:10), c(25:35), c(7:18)))
}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
