% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaya.R
\name{jaya}
\alias{jaya}
\title{Jaya Algorithm, a gradient-free optimization algorithm.
Maximization of a function using Jaya Algorithm (JA).
A population based method which repeatedly modifies a population of individual solutions.
Capable of solving both constrained and unconstrained optimization problems.
Does not contain any hyperparameters.}
\usage{
jaya(fun, lower, upper, popSize = 50, maxiter, n_var, seed = NULL,
  suggestions = data.frame(), opt = "minimize")
}
\arguments{
\item{fun}{as a function to be optimized}

\item{lower}{as a vector of lower bounds for the vaiables in the function}

\item{upper}{as a vector of upper bounds for the vaiables in the function}

\item{popSize}{as population size}

\item{maxiter}{as number of iterations to run for finding optimum solution}

\item{n_var}{as number of variables used in the function to optimize}

\item{seed}{as an integer vector containing the random number generator state}

\item{suggestions}{as a data frame of solutions string to be included in the initial population}

\item{opt}{as a string either "maximize" or "minimize" the function}
}
\description{
Jaya Algorithm, a gradient-free optimization algorithm.
Maximization of a function using Jaya Algorithm (JA).
A population based method which repeatedly modifies a population of individual solutions.
Capable of solving both constrained and unconstrained optimization problems.
Does not contain any hyperparameters.
}
\examples{
# Test Function to minimize
square <- function(x){return((x[1]^2)+(x[2]^2))}
jaya(fun = square, lower = c(-100,-100), upper = c(100,100), maxiter = 10, n_var = 2)
}
\keyword{optimization}
