% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_distribution.R
\name{latent_distribution}
\alias{latent_distribution}
\title{Latent density function}
\usage{
latent_distribution(x, model.fit)
}
\arguments{
\item{x}{A numeric vector. Value(s) on the \eqn{theta} scale for evaluating the PDF.}

\item{model.fit}{An object returned from an estimation function.}
}
\value{
The evaluated values of the PDF, a length of which equals to that of \code{x}.
}
\description{
Density function of the estimated latent distribution with mean and standard deviation equal to 0 and 1, respectively.
}
\examples{
\donttest{
# Data generation and model fitting
data <- DataGeneration(N=1000,
                       nitem_D = 15,
                       latent_dist = "2NM",
                       d = 1.664,
                       sd_ratio = 2,
                       prob = 0.3)$data_D

M1 <- IRTest_Dich(data = data, latent_dist = "KDE")

# Plotting the latent distribution
ggplot2::ggplot()+
  ggplot2::stat_function(fun=latent_distribution, args=list(M1))+
  ggplot2::lims(x=c(-6,6), y=c(0,0.5))
}
}
