% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ind_Evaluation_30112018.R
\name{adjusted.weight.SI}
\alias{adjusted.weight.SI}
\title{Calculates the adjusted weight for a given sub-item of a linguistic questionnaire}
\usage{
adjusted.weight.SI(x, i, k, b_jk)
}
\arguments{
\item{x}{the data set to evaluate.}

\item{i}{an observation index.}

\item{k}{a sub-item index.}

\item{b_jk}{an array referring to the initial weights given to each sub-item of the considered main-item. This array will be afterwards re-calculated.}
}
\value{
A numerical value giving the readjusted weight of the sub-item k of the considered main-item for the observation i.
}
\description{
Calculates the adjusted weight for a given sub-item of a linguistic questionnaire
}
\examples{
data <- matrix(c(3,4,2,3,3,2,4,3,3,4,3,4,4,2,5,3,4,4,3,3,3,4,4,3,
3,3,4,3,3,3,3,4,4,3,5,3,4,3,3,3), ncol = 4)
adjusted.weight.SI(data, 7, 1, c(0.5,0.5))
}
