% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.marginalplot}
\alias{FD.marginalplot}
\title{Marginal Plot of a Flexible Dirichlet}
\usage{
FD.marginalplot(x, var, zoomed = T, showgrid = T, showdata = T)
}
\arguments{
\item{x}{an object of class FDfitted, usually the result of \code{\link{FD.estimation}}.}

\item{var}{position of the variable to be plotted.}

\item{zoomed}{if \code{TRUE}, shows only the area where most of the density is concentrated. If \code{FALSE}, shows the whole range \code{[0;1]}.}

\item{showgrid}{if \code{TRUE}, shows the axis and the labels. If \code{FALSE}, only the graph is printed.}

\item{showdata}{if \code{TRUE}, prints the histogram of the data. If \code{FALSE}, shows only the density function.}
}
\description{
Histogram of the observed marginal variable and estimated density function of the marginal variable of a fitted Flexible Dirichlet distribution.
}
\examples{
data <- FD.generate(n=20,a=c(12,7,15),p=c(0.3,0.4,0.3),t=8)
data
results <- FD.estimation(data, normalize=TRUE,iter.initial.SEM = 5,iter.final.EM = 10)
results
FD.marginalplot(results, var=2)
FD.marginalplot(results, var=2, zoomed=FALSE, showgrid=TRUE, showdata=FALSE)


}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.estimation}}, \code{\link{FD.ternaryplot}}, \code{\link{FD.rightplot}}
}
