% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{BIC.femlm}
\alias{BIC.femlm}
\title{Bayesian information criterion}
\usage{
\method{BIC}{femlm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{...}{Optionally, more fitted objects.}
}
\value{
It return a numeric vector, with length the same as the number of objects taken as arguments.
}
\description{
This function computes the BIC (Bayesian information criterion) from a \code{\link[FENmlm]{femlm}} estimation.
}
\details{
The BIC is computed as follows:
\deqn{BIC = -2\times LogLikelihood + \log(nobs)\times nbParams}
with k the penalty parameter.

You can have more information on this crtierion on \code{\link[stats]{AIC}}.
}
\examples{

# two fitted models with different expl. variables:
res1 = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)
res2 = femlm(Sepal.Length ~ Petal.Width | Species, iris)

AIC(res1, res2)
BIC(res1, res2)

}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{AIC.femlm}}, \code{\link[FENmlm]{logLik.femlm}}.
}
\author{
Laurent Berge
}
