\name{FcnsByCatEstDistQuants}
\alias{FcnsByCatEstDistQuants}
\alias{Estimating Distribution Quantiles}
\concept{Estimation}
\concept{Quantile}
\concept{Percentile}
\title{
  EnvStats Functions for Estimating Distribution Quantiles
}
\description{
  The \pkg{EnvStats} functions listed below are useful for estimating distribution quantiles
  and, for some functions, optionally constructing confidence intervals for a quantile.
}
\details{
  \tabular{ll}{
  \emph{Function Name}                    \tab \emph{Description} \cr
  \code{\link{eqbeta}}                    \tab Estimate quantiles of a \link{Beta} distribution. \cr
  \code{\link{eqbinom}}                   \tab Estimate quantiles of a \link{Binomial} distribution. \cr
  \code{\link{eqexp}}                     \tab Estimate quantiles of an \link{Exponential} distribution. \cr
  \code{\link{eqevd}}                     \tab Estimate quantiles of an \link[=EVD]{Extreme Value} distribution. \cr
  \code{\link{eqgamma}}                   \tab Estimate quantiles of a \link[=GammaDist]{Gamma} distribution \cr
                                          \tab using the Shape and Scale Parameterization, and optionally \cr
                                          \tab construct a confidence interval for a quantile. \cr
  \code{\link{eqgammaAlt}}                \tab Estimate quantiles of a \link[=GammaAlt]{Gamma} distribution \cr
                                          \tab using the mean and CV Parameterization, and optionally \cr
                                          \tab construct a confidence interval for a quantile. \cr
  \code{\link{eqgevd}}                    \tab Estimate quantiles of a \link[=GEVD]{Generalized Extreme Value} distribution. \cr
  \code{\link{eqgeom}}                    \tab Estimate quantiles of a \link{Geometric} distribution. \cr
  \code{\link{eqhyper}}                   \tab Estimate quantiles of a \link{Hypergeometric} distribution. \cr
  \code{\link{eqlogis}}                   \tab Estimate quantiles of a \link{Logistic} distribution. \cr
  \code{\link{eqlnorm}}                   \tab Estimate quantiles of a \link{Lognormal} distribution (log-scale), \cr
                                          \tab and optionally construct a confidence interval for a quantile. \cr
  \code{\link{eqlnorm3}}                  \tab Estimate quantiles of a \link[=Lognormal3]{Three-Parameter Lognormal} distribution. \cr
  \code{\link{eqnbinom}}                  \tab Estimate quantiles of a \link[=NegBinomial]{Negative Binomial} distribution. \cr
  \code{\link{eqnorm}}                    \tab Estimate quantiles of a \link{Normal} distribution, \cr
                                          \tab and optionally construct a confidence interval for a quantile. \cr
  \code{\link{eqpareto}}                  \tab Estimate quantiles of a \link{Pareto} distribution. \cr
  \code{\link{eqpois}}                    \tab Estimate quantiles of a \link{Poisson} distribution, \cr
                                          \tab and optionally construct a confidence interval for a quantile. \cr
  \code{\link{equnif}}                    \tab Estimate quantiles of a \link{Uniform} distribution. \cr
  \code{\link{eqweibull}}                 \tab Estimate quantiles of a \link{Weibull} distribution. \cr
  \code{\link{eqzmlnorm}}                 \tab Estimate quantiles of a \link[=DeltaDist]{Zero-Modified Lognormal (Delta)} \cr
                                          \tab distribution (log-scale). \cr
  \code{\link{eqzmlnormAlt}}              \tab Estimate quantiles of a \link[=DeltaDistAlt]{Zero-Modified Lognormal (Delta)} \cr
                                          \tab distribution (original scale). \cr
  \code{\link{eqzmnorm}}                  \tab Estimate quantiles of a \link[=ZeroModifiedNormal]{Zero-Modified Normal} distribution. \cr
  }
}
\keyword{ package }
