% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutiple_testing_correction.R
\name{multiple_testing_correction}
\alias{multiple_testing_correction}
\title{Correction for multiple testing}
\usage{
multiple_testing_correction(p.values, method = "BH")
}
\arguments{
\item{p.values}{a vector of p.values}

\item{method}{method of correction: c(\code{"BH"}, \code{"bonferroni"})}
}
\value{
vector of q-values
}
\description{
Correction for multiple testing
}
\details{
Correction for multiple testing
}
\examples{
graph = graph_generation(n.nodes = 10, prob.connection = 0.5)
initial_score = c(rep(0,5),0.2, 0.3, 0, 0, 0.5)
names(initial_score) = igraph::V(graph)
Actual_score = actual_score(graph = graph, initial.score = initial_score, damping = 0.7)
Null_score = null_score(graph = graph, initial.score = initial_score, damping = 0.7, N.repeat = 10)
pvalue = pval(actual.scores = Actual_score, null.scores = Null_score, method = "non_parametric")
adj_nodes = multiple_testing_correction(pvalue)
}
