% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\name{plot.DiSSMod}
\alias{plot.DiSSMod}
\title{Relative Log Likelihood Plot for Discrete Sample Selection Model Fits}
\usage{
\method{plot}{DiSSMod}(x, ...)
}
\arguments{
\item{x}{an object of class "DiSSMod" made by the function \code{DiSSMod}.}

\item{\dots}{additional control argument is as follows.
\itemize{
\item \code{level}: an option for controlling the significance level of confidence interval.
It has to be given in probability between 0 and 1. Initial level is set to \eqn{1 - \alpha = 0.95}.
}}
}
\description{
\code{plot} method for a class \code{"DiSSMod"}.
}
\details{
Function \code{plot} draws a convex line due to the values of twice relative
log likelihoods by using the profile likelihood approach with
following the grids of \code{alpha}. If confidence interval created from
the function \code{confint} exists between the maximum and minimum value of the \code{alpha},
there will be two points drawn with the color red. Also, the Maximum Likelihood Estimator (MLE)
of \code{alpha} can be seen easily, if it exists between the maximum and minimum value of
the \code{alpha}.
}
\examples{
# example continued from DiSSMod
set.seed(45)
data(DoctorRWM, package = "DiSSMod")
n0 <- 600
set.n0 <- sample(1:nrow(DoctorRWM), n0)
reduce_DoctorRWM <- DoctorRWM[set.n0,]
result0 <- DiSSMod(response = as.numeric(DOCVIS > 0) ~ AGE + INCOME_SCALE + HHKIDS + EDUC + MARRIED,
                   selection = PUBLIC ~ AGE + EDUC + FEMALE,
                   data = reduce_DoctorRWM, resp.dist="bernoulli", select.dist = "normal",
                   alpha = seq(-5.5, -0.5, length.out = 21), standard = TRUE)

plot(result0, level = 0.90)

data(CreditMDR, package = "DiSSMod")
n1 <- 600
set.n1 <- sample(1:nrow(CreditMDR), n1)
reduce_CreditMDR <- CreditMDR[set.n1,]
result1 <- DiSSMod(response = MAJORDRG ~ AGE + INCOME + EXP_INC,
                   selection = CARDHLDR ~ AGE + INCOME + OWNRENT + ADEPCNT + SELFEMPL,
                   data = reduce_CreditMDR, resp.dist="poi", select.dist = "logis",
                   alpha = seq(-0.3, 0.3,length.out = 21), standard = FALSE, verbose = 1)

plot(result1)

}
\seealso{
See also \code{\link{DiSSMod}} and \code{\link[graphics]{plot}}.
}
