% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\name{coef.DiSSMod}
\alias{coef.DiSSMod}
\title{Getting Coefficients of Discrete Sample Selection Model Fits}
\usage{
\method{coef}{DiSSMod}(object, only = NULL, ...)
}
\arguments{
\item{object}{an object of class "DiSSMod" made by the function \code{DiSSMod}.}

\item{only}{a character value for choosing specific variable's coefficients. Initial value is}

\item{\dots}{not used, but exists because of the compatibility.
\code{NULL}, which shows all variable's coefficients. If \code{"response"} is written,
 only coefficients for response variables will be returned, and if \code{"selection"} is written,
 only coefficients for selection variables will be returned.}
}
\value{
a numeric vector or a list is given.
}
\description{
\code{coef} method for a class \code{"DiSSMod"}.
}
\details{
It looks as similar as the generic function \code{coef}, but this case there
are two equations. Therefore, there exist little differences.
}
\examples{
# example continued from DiSSMod
set.seed(45)
data(DoctorRWM, package = "DiSSMod")
n0 <- 600
set.n0 <- sample(1:nrow(DoctorRWM), n0)
reduce_DoctorRWM <- DoctorRWM[set.n0,]
result0 <- DiSSMod(response = as.numeric(DOCVIS > 0) ~ AGE + INCOME_SCALE + HHKIDS + EDUC + MARRIED,
                   selection = PUBLIC ~ AGE + EDUC + FEMALE,
                   data = reduce_DoctorRWM, resp.dist="bernoulli", select.dist = "normal",
                   alpha = seq(-5.5, -0.5, length.out = 21), standard = TRUE)

coef(result0)

data(CreditMDR, package = "DiSSMod")
n1 <- 600
set.n1 <- sample(1:nrow(CreditMDR), n1)
reduce_CreditMDR <- CreditMDR[set.n1,]
result1 <- DiSSMod(response = MAJORDRG ~ AGE + INCOME + EXP_INC,
                   selection = CARDHLDR ~ AGE + INCOME + OWNRENT + ADEPCNT + SELFEMPL,
                   data = reduce_CreditMDR, resp.dist="poi", select.dist = "logis",
                   alpha = seq(-0.3, 0.3,length.out = 21), standard = FALSE, verbose = 1)

coef(result1)

}
\seealso{
See also \code{\link{DiSSMod}} and \code{\link[stats]{coef}}.
}
