% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colQuantiles.R, R/rowQuantiles.R
\name{colQuantiles,DelayedMatrix-method}
\alias{colQuantiles,DelayedMatrix-method}
\alias{rowQuantiles,DelayedMatrix-method}
\title{Calculates quantiles for each row (column) of a matrix-like object}
\usage{
\S4method{colQuantiles}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25),
  na.rm = FALSE,
  type = 7L,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE,
  drop = TRUE
)

\S4method{rowQuantiles}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25),
  na.rm = FALSE,
  type = 7L,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE,
  drop = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{probs}{A numeric vector of J probabilities in [0, 1].}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{type}{An integer specifying the type of estimator. See
\code{stats::\link[stats]{quantile}()}. for more details.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}

\item{drop}{If \code{TRUE} a vector is returned if \code{J == 1}.}
}
\value{
a \code{\link{numeric}} \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) for
which the J values are calculated.
}
\description{
Calculates quantiles for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowQuantiles}} /
\code{matrixStats::\link[matrixStats]{colQuantiles}}.
}
\examples{
# A DelayedMatrix with a 'data.frame' seed
dm_df <- DelayedArray(data.frame(C1 = rep(1L, 5),
                                 C2 = as.integer((0:4) ^ 2),
                                 C3 = seq(-5L, -1L, 1L)))

# colnames, if present, are preserved as rownames on output
colQuantiles(dm_df)

# Input has no rownames so output has no rownames
rowQuantiles(dm_df)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowQuantiles}()} and
\code{matrixStats::\link[matrixStats:rowQuantiles]{colQuantiles}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item \link[stats:quantile]{stats::quantile}
}
}
\author{
Peter Hickey
}
