% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{values.DTSg}
\alias{values.DTSg}
\alias{values}
\title{Get values}
\usage{
\method{values}{DTSg}(
  x,
  reference = FALSE,
  drop = FALSE,
  class = c("data.table", "data.frame"),
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{reference}{A logical specifying if a copy of the values or a reference
to the values shall be returned. See corresponding section for further
information.}

\item{drop}{A logical specifying if the object and all references to it shall
be removed from the global (and only the global) environment after
successfully returning its values. This feature allows for a resource
efficient destruction of a \code{\link{DTSg}} object while preserving its values.}

\item{class}{A character string specifying the class of the returned values.
\code{"data.frame"} only works when either a copy of the values is returned or
the object is dropped.}

\item{...}{Not used (S3 method only).}
}
\value{
Returns a \code{\link[data.table:data.table]{data.table::data.table}}, a reference to a
\code{\link[data.table:data.table]{data.table::data.table}} or a \code{\link{data.frame}}.
}
\description{
Returns the values of a \code{\link{DTSg}} object.
}
\note{
The original name of the \emph{.dateTime} column is restored when not returned as
a reference or when dropped.
}
\section{Reference to the values}{

A reference to the values of a \code{\link{DTSg}} object can be used to modify them in
place. This includes the \emph{.dateTime} column, which serves as the object's
time index. Modifying this column can therefore endanger the object's
integrity. In case needs to do so ever arise, \code{\link{refresh}} should be called
immediately afterwards in order to check the object's integrity.
}

\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get values
## R6 method
x$values()

## S3 method
values(x = x)

}
