# Generated by helper-dev.R, do not edit by hand
# Sources: R/spec-meta-bind-.R, R/spec-meta-bind-expr.R, R/spec-meta-bind-runner.R

# This file is generated during load_all() if it's older than the sources

spec_meta_stream_bind <- list(
  stream_bind_return_value = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:18>
    # @return
    # `dbBind()` returns the result set,
    # invisibly,
    # for queries issued by [dbSendQuery()] or [dbSendQueryArrow()] and
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbFetch(res))
      expect_equal(dbGetRowCount(res), 0)
      expect_true(dbIsValid(res))
      expect_false(dbHasCompleted(res))
      bind_res <- withVisible(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values)))
      expect_identical(res, bind_res$value)
      expect_false(bind_res$visible)
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_return_value_statement = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:36>
    # also for data manipulation statements issued by
    # [dbSendStatement()].
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    allow_na_rows_affected <- ctx$tweaks$allow_na_rows_affected
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      data <- data.frame(a = rep(1:5, 1:5), b = 1:15)
      table_name <- random_table_name()
      dbWriteTable(con, table_name, data, temporary = TRUE)
      sql <- paste0("UPDATE ", dbQuoteIdentifier(con, table_name), " SET b = b + 1 WHERE ")
      sql <- paste0(sql, "a = ", placeholder[[1L]])
      res <- dbSendStatement(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_identical(dbGetRowsAffected(res), NA_integer_)
      expect_true(dbIsValid(res))
      expect_false(dbHasCompleted(res))
      bind_res <- withVisible(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values)))
      expect_identical(res, bind_res$value)
      expect_false(bind_res$visible)
      rows_affected <- dbGetRowsAffected(res)
      if (!isTRUE(allow_na_rows_affected) || !is.na(rows_affected)) {
        expect_equal(rows_affected, 1L)
      }
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_too_many = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:53>
    # @section Failure modes:
    # Binding too many
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- if (is.null(names(bind_values))) {
        c(bind_values, bind_values[[1L]])
      } else {
        c(bind_values, bogus = bind_values[[1L]])
      }
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_not_enough = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:72>
    # or not enough values,
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, 2L, check.names = FALSE), names = c("", ""))
      placeholder <- placeholder_fun(2L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- bind_values[-1L]
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_wrong_name = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:86>
    # or parameters with wrong names
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = TRUE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- stats::setNames(bind_values, paste0("bogus", names(bind_values)))
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_named_param_unnamed_placeholders = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:118>
    # If the placeholders in the query are named,
    # all parameter values must have names
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = TRUE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- stats::setNames(bind_values, NULL)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_named_param_empty_placeholders = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:134>
    # (which must not be empty
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = TRUE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, 2L, check.names = FALSE), names = c("", ""))
      placeholder <- placeholder_fun(2L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- {
        names(bind_values)[[1]] <- ""
        bind_values
      }
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_named_param_na_placeholders = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:150>
    # or `NA`),
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = TRUE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, 2L, check.names = FALSE), names = c("", ""))
      placeholder <- placeholder_fun(2L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- {
        names(bind_values)[[1]] <- NA
        bind_values
      }
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_unnamed_param_named_placeholders = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:166>
    # and vice versa,
    # otherwise an error is raised.
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = FALSE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- stats::setNames(bind_values, letters[seq_along(bind_values)])
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched)), ".*")
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_premature_clear = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:187>
    # Calling `dbBind()` on a result set already cleared by [dbClearResult()]
    # also raises an error.
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      dbClearResult(res)
      expect_error(dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values)), ".*")
    }
  },
  stream_bind_multi_row = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:200>
    # @section Specification:
    # The elements of the `params` argument do not need to be scalars,
    # vectors of arbitrary length
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1:3, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 3L)
      result <- data.frame(a = c(1.5, 2.5, 2.5))
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_multi_row_zero_length = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:211>
    # (including length 0)
    # are supported.
    # For queries, calling `dbFetch()` binding such parameters returns
    # concatenated results, equivalent to binding and fetching for each set
    # of values and connecting via [rbind()].
    skip_if_not_dbitest(ctx, "1.7.99.12")
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(integer(0), integer(0), check.names = FALSE), names = c("", ""))
      placeholder <- placeholder_fun(2L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 0L)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_multi_row_statement = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:227>
    # For data manipulation statements, `dbGetRowsAffected()` returns the
    # total number of rows affected if binding non-scalar parameters.
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    allow_na_rows_affected <- ctx$tweaks$allow_na_rows_affected
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1:3, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      data <- data.frame(a = rep(1:5, 1:5), b = 1:15)
      table_name <- random_table_name()
      dbWriteTable(con, table_name, data, temporary = TRUE)
      sql <- paste0("UPDATE ", dbQuoteIdentifier(con, table_name), " SET b = b + 1 WHERE ")
      sql <- paste0(sql, "a = ", placeholder[[1L]])
      res <- dbSendStatement(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows_affected <- dbGetRowsAffected(res)
      if (!isTRUE(allow_na_rows_affected) || !is.na(rows_affected)) {
        expect_equal(rows_affected, 6L)
      }
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_repeated = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:239>
    # `dbBind()` also accepts repeated calls on the same result set
    # for both queries
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5)
      expect_equal(rows, result)
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_repeated_statement = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:252>
    # and data manipulation statements,
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    allow_na_rows_affected <- ctx$tweaks$allow_na_rows_affected
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      data <- data.frame(a = rep(1:5, 1:5), b = 1:15)
      table_name <- random_table_name()
      dbWriteTable(con, table_name, data, temporary = TRUE)
      sql <- paste0("UPDATE ", dbQuoteIdentifier(con, table_name), " SET b = b + 1 WHERE ")
      sql <- paste0(sql, "a = ", placeholder[[1L]])
      res <- dbSendStatement(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows_affected <- dbGetRowsAffected(res)
      if (!isTRUE(allow_na_rows_affected) || !is.na(rows_affected)) {
        expect_equal(rows_affected, 1L)
      }
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows_affected <- dbGetRowsAffected(res)
      if (!isTRUE(allow_na_rows_affected) || !is.na(rows_affected)) {
        expect_equal(rows_affected, 1L)
      }
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_repeated_untouched = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:265>
    # even if no results are fetched between calls to `dbBind()`,
    # for both queries
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_repeated_untouched_statement = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:280>
    # and data manipulation statements.
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    allow_na_rows_affected <- ctx$tweaks$allow_na_rows_affected
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, check.names = FALSE), names = "")
      placeholder <- placeholder_fun(1L)
      names(bind_values) <- names(placeholder)
      data <- data.frame(a = rep(1:5, 1:5), b = 1:15)
      table_name <- random_table_name()
      dbWriteTable(con, table_name, data, temporary = TRUE)
      sql <- paste0("UPDATE ", dbQuoteIdentifier(con, table_name), " SET b = b + 1 WHERE ")
      sql <- paste0(sql, "a = ", placeholder[[1L]])
      res <- dbSendStatement(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows_affected <- dbGetRowsAffected(res)
      if (!isTRUE(allow_na_rows_affected) || !is.na(rows_affected)) {
        expect_equal(rows_affected, 1L)
      }
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_named_param_shuffle = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:296>
    # If the placeholders in the query are named,
    # their order in the `params` argument is not important.
    placeholder_funs <- get_placeholder_funs(ctx, requires_names = TRUE)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1.5, 2.5, 3.5, NA_real_, check.names = FALSE), names = rep("", 4L))
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      bind_values_patched <- bind_values[c(3, 1, 2, 4)]
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values_patched))
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_integer = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:312>
    # At least the following data types are accepted on input (including [NA]):
    # - [integer]
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1L, 2L, 3L, NA_integer_, check.names = FALSE), names = rep("", 4L))
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_numeric = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:322>
    # - [numeric]
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(1.5, 2.5, 3.5, NA_real_, check.names = FALSE), names = rep("", 4L))
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_logical = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:331>
    # - [logical] for Boolean values
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(data.frame(TRUE, FALSE, NA, check.names = FALSE), names = rep("", 3L))
      placeholder <- placeholder_fun(3L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[3L] <- paste0("(", is_null_check(placeholder[3L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_character = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:340>
    # - [character]
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame("\U{41A}\U{438}\U{440}\U{438}\U{43B}\U{43B}", "M\U{FC}ller", "M\U{FC}ller", "\U{6211}\U{662F}\U{8C01}", "ASCII", NA_character_, check.names = FALSE),
        names = rep("", 6L)
      )
      placeholder <- placeholder_fun(6L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[6L] <- paste0("(", is_null_check(placeholder[6L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[5L]], " THEN 1.5 ELSE 2.5 END AS e, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[6L]], " THEN 1.5 ELSE 2.5 END AS f")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5, e = 1.5, f = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_character_escape = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:349>
    # (also with special characters such as spaces, newlines, quotes, and backslashes)
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(" ", "\n", "\r", "\b", "'", '"', "[", "]", "\\", NA_character_, check.names = FALSE),
        names = rep("", 10L)
      )
      placeholder <- placeholder_fun(10L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[10L] <- paste0("(", is_null_check(placeholder[10L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[5L]], " THEN 1.5 ELSE 2.5 END AS e, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[6L]], " THEN 1.5 ELSE 2.5 END AS f, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[7L]], " THEN 1.5 ELSE 2.5 END AS g, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[8L]], " THEN 1.5 ELSE 2.5 END AS h, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[9L]], " THEN 1.5 ELSE 2.5 END AS i, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[10L]], " THEN 1.5 ELSE 2.5 END AS j")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5, e = 1.5, f = 1.5, g = 1.5, h = 1.5, i = 1.5, j = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_factor = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:358>
    # - [factor] (bound as character,
    # with warning)
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(factor("\U{41A}\U{438}\U{440}\U{438}\U{43B}\U{43B}"), factor("M\U{FC}ller"), factor("M\U{FC}ller"), factor("\U{6211}\U{662F}\U{8C01}"), factor("ASCII"), factor(NA_character_), check.names = FALSE),
        names = rep("", 6L)
      )
      placeholder <- placeholder_fun(6L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[6L] <- paste0("(", is_null_check(placeholder[6L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[5L]], " THEN 1.5 ELSE 2.5 END AS e, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[6L]], " THEN 1.5 ELSE 2.5 END AS f")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5, e = 1.5, f = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_date = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:370>
    # - [Date]
    skip_if(!isTRUE(ctx$tweaks$date_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(as.Date("2023-12-17"), as.Date("2023-12-18"), as.Date("2023-12-19"), as.Date(NA_character_), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_date_integer = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:380>
    # (also when stored internally as integer)
    skip_if(!isTRUE(ctx$tweaks$date_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(structure(18618L, class = "Date"), structure(18619L, class = "Date"), structure(18620L, class = "Date"), structure(NA_integer_, class = "Date"), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_timestamp = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:390>
    # - [POSIXct] timestamps
    skip_if(!isTRUE(ctx$tweaks$timestamp_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(as.POSIXct("2023-12-17 02:40:22"), as.POSIXct("2023-12-17 02:40:23"), as.POSIXct("2023-12-17 02:40:24"), as.POSIXct(NA_character_), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_timestamp_lt = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:406>
    # - [POSIXlt] timestamps
    skip_if(!isTRUE(ctx$tweaks$timestamp_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(as.POSIXct("2023-12-17 02:40:49"), as.POSIXct("2023-12-17 02:40:50"), as.POSIXct("2023-12-17 02:40:51"), as.POSIXct(NA_character_), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_time_seconds = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:422>
    # - [difftime] values
    skip_if(!isTRUE(ctx$tweaks$time_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(structure(1, class = "difftime", units = "secs"), structure(2, class = "difftime", units = "secs"), structure(3, class = "difftime", units = "secs"), structure(NA_real_, class = "difftime", units = "secs"), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_time_hours = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:433>
    # (also with units other than seconds
    skip_if(!isTRUE(ctx$tweaks$time_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(structure(1, class = "difftime", units = "hours"), structure(2, class = "difftime", units = "hours"), structure(3, class = "difftime", units = "hours"), structure(NA_real_, class = "difftime", units = "hours"), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_time_minutes_integer = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:444>
    # and with the value stored as integer)
    skip_if(!isTRUE(ctx$tweaks$time_typed))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        data.frame(structure(1, class = "difftime", units = "mins"), structure(2, class = "difftime", units = "mins"), structure(3, class = "difftime", units = "mins"), structure(NA_real_, class = "difftime", units = "mins"), check.names = FALSE),
        names = rep("", 4L)
      )
      placeholder <- placeholder_fun(4L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", placeholder, " = ", placeholder_values, ")")
      result_check[4L] <- paste0("(", is_null_check(placeholder[4L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[4L]], " THEN 1.5 ELSE 2.5 END AS d")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5, d = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  stream_bind_blob = function(ctx, con) {
    # <R/spec-meta-bind-expr.R:467>
    # - objects of type [blob::blob]
    skip_if(isTRUE(ctx$tweaks$omit_blob_tests))
    placeholder_funs <- get_placeholder_funs(ctx)
    is_null_check <- ctx$tweaks$is_null_check
    cast_fun <- ctx$tweaks$blob_cast
    for (placeholder_fun in placeholder_funs) {
      bind_values <- structure(
        list(
          structure(vctrs::list_of(as.raw(c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)), .ptype = raw(0)), class = c("blob", "vctrs_list_of", "vctrs_vctr", "list")),
          structure(vctrs::list_of(raw(3), .ptype = raw(0)), class = c("blob", "vctrs_list_of", "vctrs_vctr", "list")),
          structure(vctrs::list_of(NULL, .ptype = raw(0)), class = c("blob", "vctrs_list_of", "vctrs_vctr", "list"))
        ),
        names = rep("", 3L),
        class = "data.frame",
        row.names = 1L
      )
      placeholder <- placeholder_fun(3L)
      names(bind_values) <- names(placeholder)
      placeholder_values <- map_chr(bind_values, function(x) DBI::dbQuoteLiteral(con, x[1]))
      result_check <- paste0("(", cast_fun(placeholder), " = ", placeholder_values, ")")
      result_check[3L] <- paste0("(", is_null_check(cast_fun(placeholder)[3L]), ")")
      sql <- "SELECT "
      sql <- paste0(sql, "CASE WHEN ", result_check[[1L]], " THEN 1.5 ELSE 2.5 END AS a, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[2L]], " THEN 1.5 ELSE 2.5 END AS b, ")
      sql <- paste0(sql, "CASE WHEN ", result_check[[3L]], " THEN 1.5 ELSE 2.5 END AS c")
      res <- dbSendQuery(con, sql)
      on.exit(if (!is.null(res)) expect_error(dbClearResult(res), NA))
      dbBindArrow(res, nanoarrow::as_nanoarrow_array_stream(bind_values))
      rows <- check_df(dbFetch(res))
      expect_equal(nrow(rows), 1L)
      result <- data.frame(a = 1.5, b = 1.5, c = 1.5)
      expect_equal(rows, result)
      expect_error(dbClearResult(res), NA)
      res <- NULL
    }
  },
  NULL
)
