% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-arrow-get-query-arrow.R
\docType{data}
\name{spec_arrow_get_query_arrow}
\alias{spec_arrow_get_query_arrow}
\title{spec_arrow_get_query_arrow}
\value{
\code{dbGetQueryArrow()} always returns an object coercible to a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
}
\description{
spec_arrow_get_query_arrow
}
\section{Failure modes}{

An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
The object returned by \code{dbGetQueryArrow()} can also be passed to
\code{\link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow::as_nanoarrow_array_stream()}} to create a nanoarrow
array stream object that can be used to read the result set
in batches.
The chunk size is implementation-specific.
}

\seealso{
Other Arrow specifications: 
\code{\link{spec_arrow_append_table_arrow}},
\code{\link{spec_arrow_create_table_arrow}},
\code{\link{spec_arrow_fetch_arrow}},
\code{\link{spec_arrow_read_table_arrow}},
\code{\link{spec_arrow_send_query_arrow}},
\code{\link{spec_arrow_write_table_arrow}},
\code{\link{spec_result_clear_result}}
}
\concept{Arrow specifications}
