% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-arrow-create-table-arrow.R
\docType{data}
\name{spec_arrow_create_table_arrow}
\alias{spec_arrow_create_table_arrow}
\title{spec_arrow_create_table_arrow}
\value{
\code{dbCreateTableArrow()} returns \code{TRUE}, invisibly.
}
\description{
spec_arrow_create_table_arrow
}
\section{Failure modes}{

If the table exists, an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Invalid values for the \code{temporary} argument
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate names)
also raise an error.
}

\section{Additional arguments}{

The following arguments are not part of the \code{dbCreateTableArrow()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{temporary} (default: \code{FALSE})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.
}

\section{Specification}{

The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbCreateTableArrow()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}

If the \code{temporary} argument is \code{TRUE}, the table is not available in a
second connection and is gone after reconnecting.
Not all backends support this argument.
A regular, non-temporary table is visible in a second connection,
in a pre-existing connection,
and after reconnecting to the database.

SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, and spaces can also be used  for table names and column names,
if the database supports non-syntactic identifiers.
}

\seealso{
Other Arrow specifications: 
\code{\link{spec_arrow_append_table_arrow}},
\code{\link{spec_arrow_fetch_arrow}},
\code{\link{spec_arrow_get_query_arrow}},
\code{\link{spec_arrow_read_table_arrow}},
\code{\link{spec_arrow_send_query_arrow}},
\code{\link{spec_arrow_write_table_arrow}},
\code{\link{spec_result_clear_result}}
}
\concept{Arrow specifications}
