% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-all.R, R/test-getting-started.R,
%   R/test-driver.R, R/test-connection.R, R/test-result.R, R/test-sql.R,
%   R/test-meta.R, R/test-transaction.R, R/test-arrow.R, R/test-compliance.R,
%   R/test-stress.R
\name{test_all}
\alias{test_all}
\alias{test_some}
\title{Run all tests}
\usage{
test_all(skip = NULL, run_only = NULL, ctx = get_default_context())

test_some(test, ctx = get_default_context(), dblog = TRUE)
}
\arguments{
\item{skip}{\verb{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.
The regular expressions are matched against the entire test name.}

\item{run_only}{\verb{[character()]}\cr A vector of regular expressions to match
against test names; run only these tests.
The regular expressions are matched against the entire test name.}

\item{ctx}{\verb{[DBItest_context]}\cr A test context as created by
\code{\link[=make_context]{make_context()}}.}

\item{test}{\verb{[character]}\cr
A character vector of regular expressions
describing the tests to run.
The regular expressions are matched against the entire test name.}

\item{dblog}{\verb{[logical(1)]}\cr
Set to \code{FALSE} to disable dblog integration.}
}
\description{
\code{test_all()} calls all tests defined in this package (see the section
"Tests" below). This function supports running only one test by setting an
environment variable, e.g., set the \code{DBITEST_ONLY_RESULT} to a nonempty
value to run only \code{test_result()}.

\code{test_some()} allows testing one or more tests.
}
\details{
Internally \code{^} and \code{$} are used as prefix and suffix around the
regular expressions passed in the \code{skip} and \code{run_only} arguments.
}
\section{Tests}{

This function runs the following tests, except the stress tests:


\code{\link[=test_getting_started]{test_getting_started()}}:
Getting started with testing


\code{\link[=test_driver]{test_driver()}}:
Test the "Driver" class


\code{\link[=test_connection]{test_connection()}}:
Test the "Connection" class


\code{\link[=test_result]{test_result()}}:
Test the "Result" class


\code{\link[=test_sql]{test_sql()}}:
Test SQL methods


\code{\link[=test_meta]{test_meta()}}:
Test metadata functions


\code{\link[=test_transaction]{test_transaction()}}:
Test transaction functions


\code{\link[=test_arrow]{test_arrow()}}:
Test Arrow methods


\code{\link[=test_compliance]{test_compliance()}}:
Test full compliance to DBI


\code{\link[=test_stress]{test_stress()}}:
Stress tests (not tested with \code{test_all})
}

