% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbColumnInfo.R
\name{dbColumnInfo}
\alias{dbColumnInfo}
\title{Information about result types}
\usage{
dbColumnInfo(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbColumnInfo()}
returns a data frame
with at least two columns \code{"name"} and \code{"type"} (in that order)
(and optional columns that start with a dot).
The \code{"name"} and \code{"type"} columns contain the names and types
of the R columns of the data frame that is returned from \code{\link[DBI:dbFetch]{DBI::dbFetch()}}.
The \code{"type"} column is of type \code{character} and only for information.
Do not compute on the \code{"type"} column, instead use \code{dbFetch(res, n = 0)}
to create a zero-row data frame initialized with the correct data types.
}
\description{
Produces a data.frame that describes the output of a query. The data.frame
should have as many rows as there are output fields in the result set, and
each column in the data.frame describes an aspect of the result set
field (field name, type, etc.)

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbColumnInfo")}
}
\section{The data retrieval flow}{


This section gives a complete overview over the flow
for the execution of queries that return tabular data as data frames.

Most of this flow, except repeated calling of \code{\link[=dbBind]{dbBind()}} or \code{\link[=dbBindArrow]{dbBindArrow()}},
is implemented by \code{\link[=dbGetQuery]{dbGetQuery()}}, which should be sufficient
unless you want to access the results in a paged way
or you have a parameterized query that you want to reuse.
This flow requires an active connection established by \code{\link[=dbConnect]{dbConnect()}}.
See also \code{vignette("dbi-advanced")} for a walkthrough.
\enumerate{
\item Use \code{\link[=dbSendQuery]{dbSendQuery()}} to create a result set object of class
\linkS4class{DBIResult}.
\item Optionally, bind query parameters with \code{\link[=dbBind]{dbBind()}} or \code{\link[=dbBindArrow]{dbBindArrow()}}.
This is required only if the query contains placeholders
such as \verb{?} or \verb{$1}, depending on the database backend.
\item Optionally, use \code{\link[=dbColumnInfo]{dbColumnInfo()}} to retrieve the structure of the result set
without retrieving actual data.
\item Use \code{\link[=dbFetch]{dbFetch()}} to get the entire result set, a page of results,
or the remaining rows.
Fetching zero rows is also possible to retrieve the structure of the result set
as a data frame.
This step can be called multiple times.
Only forward paging is supported, you need to cache previous pages
if you need to navigate backwards.
\item Use \code{\link[=dbHasCompleted]{dbHasCompleted()}} to tell when you're done.
This method returns \code{TRUE} if no more rows are available for fetching.
\item Repeat the last four steps as necessary.
\item Use \code{\link[=dbClearResult]{dbClearResult()}} to clean up the result set object.
This step is mandatory even if no rows have been fetched
or if an error has occurred during the processing.
It is good practice to use \code{\link[=on.exit]{on.exit()}} or \code{\link[withr:defer]{withr::defer()}}
to ensure that this step is always executed.
}
}

\section{Failure modes}{


An attempt to query columns for a closed result set raises an error.

}

\section{Specification}{



A column named \code{row_names} is treated like any other column.

The column names are always consistent
with the data returned by \code{dbFetch()}.

If the query returns unnamed columns,
non-empty and non-\code{NA} names are assigned.

Column names that correspond to SQL or R keywords are left unchanged.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")

rs <- dbSendQuery(con, "SELECT 1 AS a, 2 AS b")
dbColumnInfo(rs)
dbFetch(rs)

dbClearResult(rs)
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIResult generics: 
\code{\link{DBIResult-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbFetch}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()}
}
\concept{DBIResult generics}
