% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbReadTable.R, R/dbReadTableArrow.R
\name{dbReadTable}
\alias{dbReadTable}
\alias{dbReadTableArrow}
\title{Copy data frames from database tables}
\usage{
dbReadTable(conn, name, ...)

dbReadTableArrow(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbReadTable()} returns a data frame that contains the complete data
from the remote table, effectively the result of calling \code{\link[=dbGetQuery]{dbGetQuery()}}
with \verb{SELECT * FROM <name>}.

An empty table is returned as a data frame with zero rows.

The presence of \link{rownames} depends on the \code{row.names} argument,
see \code{\link[=sqlColumnToRownames]{sqlColumnToRownames()}} for details:
\itemize{
\item If \code{FALSE} or \code{NULL}, the returned data frame doesn't have row names.
\item If \code{TRUE}, a column named "row_names" is converted to row names.
}

\itemize{
\item If \code{NA}, a column named "row_names" is converted to row names if it exists,
otherwise no translation occurs.
\item If a string, this specifies the name of the column in the remote table
that contains the row names.
}

The default is \code{row.names = FALSE}.

If the database supports identifiers with special characters,
the columns in the returned data frame are converted to valid R
identifiers
if the \code{check.names} argument is \code{TRUE},
If \code{check.names = FALSE}, the returned table has non-syntactic column names without quotes.
}
\description{
Reads a database table to a data frame, optionally converting
a column to row names and converting the column names to valid
R identifiers.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbReadTable")}
}
\section{Failure modes}{


An error is raised if the table does not exist.


An error is raised if \code{row.names} is \code{TRUE} and no "row_names" column exists,


An error is raised if \code{row.names} is set to a string and no corresponding column exists.


An error is raised when calling this method for a closed
or invalid connection.
An error is raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Unsupported values for \code{row.names} and \code{check.names}
(non-scalars,
unsupported data types,
\code{NA} for \code{check.names})
also raise an error.

}

\section{Additional arguments}{


The following arguments are not part of the \code{dbReadTable()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{row.names} (default: \code{FALSE})
\item \code{check.names}
}

They must be provided as named arguments.
See the "Value" section for details on their usage.

}

\section{Specification}{


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbReadTable()} will do the
quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars[1:10, ])
dbReadTable(con, "mtcars")

dbDisconnect(con)
\dontshow{if (packageVersion("arrow") >= "9.0.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read data as Arrow table
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars[1:10, ])
dbReadTableArrow(con, "mtcars")

dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}
}
\concept{DBIConnection generics}
