% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_rationet.R
\name{p_combine}
\alias{p_combine}
\title{Calculate combined p-value}
\usage{
p_combine(p, method = "sumlog", shrink = Inf)
}
\arguments{
\item{p}{the numeric vector containing the p-values need to combine.}

\item{method}{the method use to combine the p-values, can be "sumlog" (Fisher's method), "sumz" (Stouffer’s method).}

\item{shrink}{the number of p-values used in calculation, which are uniform selected from original p-value vector.}
}
\value{
This function will return a list with the following components:
  \item{p}{The combined p-value.}
  \item{v}{The value of statistic.}
  \item{chisq}{Use "sumlog" method: The value of chi-squared statistic.}
  \item{df}{Use "sumlog" method: The degrees of freedom of chi-squared distribution.}
  \item{z}{Use "sumz" method: The value of sum z statistic.}
}
\description{
Combine the statistical significance results from several independent tests by using one of several methods.
}
