% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.CopulaCenR.R
\name{fitted.CopulaCenR}
\alias{fitted.CopulaCenR}
\title{Fitted values from CopulaCenR regression models}
\usage{
\method{fitted}{CopulaCenR}(object, type = "lp", ...)
}
\arguments{
\item{object}{a \code{CopulaCenR} object from \code{ic_spTran_copula},
\code{rc_spCox_copula}, \code{ic_par_copula} and \code{rc_par_copula}}

\item{type}{\code{"lp"} for linear predictors or
\code{"survival"} for marginal and joint survival probabilities}

\item{...}{further arguments}
}
\value{
If \code{type = "lp"}, it returns a data frame with \code{id},
\code{lp1} (linear predictor for margin 1), \code{lp2}.
If \code{type = "survival"}, it returns a data frame with \code{id},
\code{t1} (evaluated times for the margin 1), \code{t2},
\code{S1} (predicted marginal survival probabilities for margin 1),
\code{S2} and \code{S12} (the predicted joint survival probabilities)
}
\description{
Fitted values based on models from \code{ic_spTran_copula}, \code{rc_spCox_copula},
\code{ic_par_copula} and \code{rc_par_copula}.
}
\details{
When the argument \code{type = "lp"}, it gives a linear predictor for each margin
(i.e., log hazards ratio in the proportional hazards model,
log proportional odds in the proportional odds model). \cr

When the argument \code{type = "survival"} and the fitted data is bivariate right-censored,
the marginal and joint survival values will be evaluated at the observed times.
For bivariate interval-censored, evaluation times are the interval middle points or
left bound (if right bound is infinity). \cr
}
\examples{
data(AREDS)
# fit a Copula2-Sieve model
copula2_sp <- ic_spTran_copula(data = AREDS, copula = "Copula2",
              l = 0, u = 15, m = 3, r = 3,
              var_list = c("ENROLLAGE","rs2284665","SevScaleBL"))
output <- fitted(object = copula2_sp)
}
