% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{normalizedBanzhafValue}
\alias{normalizedBanzhafValue}
\title{Compute normalized Banzhaf value}
\usage{
normalizedBanzhafValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a numeric vector which contains the normalized Banzhaf value for each player.
}
\description{
normalizedBanzhafValue computes the normalized Banzhaf value 
for a specified TU game. The corresponding formula can e.g. be found 
in the article by Stach (2017), p. 77.
}
\examples{
library(CoopGame)
normalizedBanzhafValue(c(0,0,0,1,2,3,6))

\donttest{
#Example from paper by Gambarelli (2011)
library(CoopGame)
v=c(0,0,0,1,2,1,3)
normalizedBanzhafValue(v)
#[1] 1.1538462 0.6923077 1.1538462
#Expected Result: 15/13  9/13  15/13
}

}
\references{
Gambarelli G. (2011) "Banzhaf value", Encyclopedia of Power, SAGE Publications, pp. 53--54

Stach I. (2017) "Sub-Coalitional Approach to Values", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXVI, Springer, pp. 74--86
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
