% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertySymmetry.R
\name{isSymmetricGame}
\alias{isSymmetricGame}
\title{Check if game is symmetric}
\usage{
isSymmetricGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is symmetric, else \code{FALSE}.
}
\description{
isSymmetricGame checks if a TU game is symmetric.
A TU game is symmetric if and only if the values of all  
coalitions containing the same number of players are identical.
}
\examples{
library(CoopGame)
isSymmetricGame(c(0,0,0,1,1,1,2))

\donttest{
#Example of a symmetric game
library(CoopGame) 
v1<-c(3,3,3,10,10,10,17)
isSymmetricGame(v1)

#Example of a game which is not symmetric 
library(CoopGame) 
v2=c(1:7)
isSymmetricGame(v2)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 12

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, p. 26
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
