% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertySemiConvexity.R
\name{isSemiConvexGame}
\alias{isSemiConvexGame}
\title{Check if game is semiconvex}
\usage{
isSemiConvexGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is semiconvex, else \code{FALSE}.
}
\description{
isSemiConvexGame checks if a TU game is semiconvex.
A TU game is semiconvex if and only if the following conditions hold true:
The gap function of any single player \code{i} is minimal among the gap 
function values of coalitions \code{S} containing player \code{i}. 
Also, the gap function itself is required to be nonnegative.
}
\examples{
library(CoopGame)
isSemiConvexGame(c(0,0,0,1,1,1,4))

\donttest{
#Example of a semiconvex game 
library(CoopGame)
v1<-c(3,4,5,9,10,11,18)
isSemiConvexGame(v1)

#Example of a game which not semiconvex 
library(CoopGame)
v2=c(1:7)
isSemiConvexGame(v2)
}

}
\references{
Driessen T. and Tijs S. (1985) "The tau-value, the core and semiconvex games", Int. Journal of Game Theory 14(4), pp. 229--247

Driessen T. (1998) \emph{Cooperative Games, Solutions and Applications}, Springer, p. 76
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
