% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeeganPackelConcept.R
\name{deeganPackelIndex}
\alias{deeganPackelIndex}
\title{Compute Deegan-Packel index}
\usage{
deeganPackelIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Deegan-Packel index for a specified simple game
}
\description{
deeganPackelIndex calculates the Deegan-Packel index for simple games
}
\examples{
library(CoopGame)
deeganPackelIndex(c(0,0,0,0,1,0,1))

\donttest{
#Example from HOLLER & ILLING (2006), chapter 6.3.3
#Expected result: dpv=(18/60,9/60,11/60,11/60,11/60)
library(CoopGame)
v1=weightedVotingGameVector(n = 5, w=c(35,20,15,15,15), q=51)
deeganPackelIndex(v1)
#Output (as expected, see HOLLER & ILLING chapter 6.3.3) :
#[1] 0.3000000 0.1500000 0.1833333 0.1833333 0.1833333
}

}
\references{
Deegan J. and  Packel E.W. (1978) "A new index of power for simple n-person games", Int. Journal of Game Theory 7(2), pp. 151--161

Holler M.J. and Illing G. (2006) "Einfuehrung in die Spieltheorie". 6th Edition (in German), Springer, pp. 323--324
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
