% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_diss.R
\name{clust_diss}
\alias{clust_diss}
\title{Calculates the aggregation criterion for two clusters of variables}
\usage{
clust_diss(A, B)
}
\arguments{
\item{A}{a centered and reduced data matrix obtained with the recod
function for the first cluster}

\item{B}{a centered and reduced data matrix obtained with the recod
function for the second cluster}
}
\value{
The aggregation measure between the two clusters
}
\description{
Calculates the measure of aggregation of two clusters of variables. This
measure of aggregation is equal to the decrease in homogeneity for the
clusters being merged.
}
\examples{
data(decathlon)
A <- PCAmixdata::recod(X.quanti=decathlon[1:10,1:5], X.quali=NULL)$Z
B <- PCAmixdata::recod(X.quanti=decathlon[1:10,6:10], X.quali=NULL)$Z
clust_diss(A,B)
}
