% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{plot_model}
\alias{plot_model}
\title{Plots a DAG in ggplot style using a causal model input}
\usage{
plot_model(
  model = NULL,
  x_coord = NULL,
  y_coord = NULL,
  labels = NULL,
  label_color = "darkgrey",
  title = "",
  textcol = "white",
  textsize = 3.88,
  shape = 16,
  nodecol = "black",
  nodesize = 16
)
}
\arguments{
\item{model}{A \code{causal_model} object generated from \code{make_model}}

\item{x_coord}{A vector of x coordinates for DAG nodes.
If left empty, coordinates are randomly generated}

\item{y_coord}{A vector of y coordinates for DAG nodes.
If left empty, coordinates are randomly generated}

\item{labels}{Optional labels for nodes}

\item{label_color}{Color for labels, if provided. Defaults to darkgrey}

\item{title}{String specifying title of graph}

\item{textcol}{String specifying color of text labels}

\item{textsize}{Numeric, size of text labels}

\item{shape}{Indicates shape of node. Defaults to circular node.}

\item{nodecol}{String indicating color of node that is accepted by
ggplot's default palette}

\item{nodesize}{Size of node.}
}
\value{
A DAG plot in ggplot style.
}
\description{
Creates a plot of a DAG using ggplot functionality.  Unmeasured confounds  (<->) are indicated
then these are represented as curved dotted lines.  Users can control node sizes and colors as well as coordinates and label behavior. Other modifications can be made by adding additional ggplot layers.
}
\examples{

\dontrun{
model <- make_model('X -> K -> Y')

# Simple plot
model |> plot_model()

# Adding addition layers
model |> plot_model() + theme(panel.border = element_rect(fill=NA))

# Adding labels
model |> plot_model(labels = c("A long label for X", "This", "That"),
 nodecol = "white")

# Controlling  positions and using math labels
model |> plot_model(
    x_coord = 1:2,
    y_coord = 1:2,
    title = "Mixed text and math: $\\\\alpha^2 + \\\\Gamma$")
}

# DAG with unobserved confounding
make_model('X -> K -> Y; X <-> Y') |> plot()
}
\keyword{internal}
