% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_models.R
\name{make_dag}
\alias{make_dag}
\title{Helper to run a causal statement specifying a DAG into a \code{data.frame} of
pairwise parent child relations between nodes specified by a respective edge.
This function reproduces the result of the following \link{dagitty} operations:
\code{dagitty::dagitty() |> dagitty::edges()}}
\usage{
make_dag(statement)
}
\arguments{
\item{statement}{character string. Statement describing causal
relations using \link{dagitty} syntax. Only directed relations are
permitted. For instance "X -> Y" or  "X1 -> Y <- X2; X1 -> X2"}
}
\value{
a \code{data.frame} with columns v,w,e specifying parent, child and
  edge respectively
}
\description{
Helper to run a causal statement specifying a DAG into a \code{data.frame} of
pairwise parent child relations between nodes specified by a respective edge.
This function reproduces the result of the following \link{dagitty} operations:
\code{dagitty::dagitty() |> dagitty::edges()}
}
\keyword{internal}
