% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab.R
\name{inspect}
\alias{inspect}
\title{inspect}
\usage{
inspect(model, what = NULL, ...)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{what}{A character string specifying the component to retrieve.
Available options are:
\itemize{
\item \code{"statement"} a character string describing causal relations using dagitty syntax,
\item \code{"dag"} A data frame with columns ‘parent’ and ‘children’ indicating how nodes relate to each other,
\item \code{"nodes"} A list containing the nodes in the model,
\item \code{"parents_df"} a table listing nodes, whether they are root nodes or not, and the number and names of parents they have,
\item \code{"parameters"} a vector of 'true' parameters,
\item \code{"parameter_names"} a  vector of names of parameters,
\item \code{"parameter_mapping"} a  matrix mapping from parameters into data types,
\item \code{"parameter_matrix"} a matrix mapping from parameters into causal types,
\item \code{"parameters_df"} a data frame containing parameter information,
\item \code{"causal_types"} a data frame listing causal types and the nodal types that produce them,
\item \code{"nodal_types"} a list with the nodal types of the model,
\item \code{"data_types"} a list with the all data  types consistent with the model; for options see \code{"?get_all_data_types"},
\item \code{"ambiguities_matrix"} a matrix mapping from causal types into data types,
\item \code{"type_prior"} a matrix of type probabilities using priors,
\item \code{"prior_hyperparameters"}  a vector of alpha values used to parameterize Dirichlet prior distributions; optionally provide node names to reduce output \code{"inspect(prior_hyperparameters, c('M', 'Y'))"}
\item \code{"prior_event_probabilities"} a vector of data (event) probabilities given a single realization of parameters; for options see \code{"?get_event_probabilities"},
\item \code{"prior_distribution"}  a data frame of the parameter prior distribution,
\item \code{"posterior_distribution"}  a data frame of the parameter posterior distribution,
\item \code{"posterior_event_probabilities"} a sample of data (event) probabilities from the posterior,
\item \code{"type_distribution"} a matrix of type probabilities using posteriors,
\item \code{"data"} the data that was provided to update the model,
\item \code{"stanfit"} the `stanfit` object generated by Stan and `stanfit` summary,
\item \code{"stan_objects"}  a list of Stan outputs that includes `stanfit`, `data`, and, if requested when updating the model, posterior `event_probabilities` and `type_distribution`.
}}

\item{...}{Other arguments passed to helper \code{"get_*"} functions.}
}
\value{
Objects from a \code{causal_model} as specified.
}
\description{
Returns specified elements from a \code{causal_model}.
Users can use \code{inspect} to extract model's components or objects implied by
the model structure including nodal types, causal types, parameter priors,
parameter posteriors, type priors, type posteriors, and other relevant elements.
See argument \code{what} for other options.
}
\examples{
\donttest{

model <- make_model("X -> Y")

inspect(model, what = "statement")
inspect(model, what = "dag")
inspect(model, what = "nodes")
inspect(model, what = "parents_df")
inspect(model, what = "parameters_df")
inspect(model, what = "causal_types")
inspect(model, what = "prior_distribution")
inspect(model, what = "posterior_distribution")
inspect(model, what = "posterior_event_probabilities")
inspect(model, what = "type_distribution")
inspect(model, what = "data")
inspect(model, what = "stanfit")
inspect(model, what = "stan_objects")

data_long   <- simulate_data(model, n = 4)
data_short  <- collapse_data(data_long, model)

model <- update_model(model, keep_type_distribution = FALSE)

inspect(model, what = "posterior_distribution")
inspect(model, what = "posterior_event_probabilities")
inspect(model, what = "type_distribution")
inspect(model, what = "data")
inspect(model, what = "stanfit")
inspect(model, what = "stan_objects")

model <-  update_model(model, data_long)

inspect(model, what = "data")

model <-  update_model(model, data_short)

inspect(model, what = "data")

model <- update_model(model,
                      keep_type_distribution = TRUE,
                      keep_event_probabilities = TRUE)

inspect(model, what = "posterior_event_probabilities")
inspect(model, what = "type_distribution")

make_model("X -> Y") |>
 inspect("prior_distribution", n_draws = 30)

}

}
