% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_causal_type.R
\name{draw_causal_type}
\alias{draw_causal_type}
\title{Draw a single causal type given a parameter vector}
\usage{
draw_causal_type(model, ...)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{...}{Arguments passed to  `set_parameters`}
}
\description{
Output is a parameter data frame recording both parameters
(case level priors) and
the case level causal type.
}
\examples{

# Simple draw using model's parameter vector
make_model("X -> M -> Y") \%>\%
draw_causal_type(.)

# Draw parameters from priors and draw type from parameters
make_model("X -> M -> Y") \%>\%
draw_causal_type(., param_type = "prior_draw")

# Draw type given specified parameters
make_model("X -> M -> Y") \%>\%
draw_causal_type(., parameters = 1:10)

# Define a causal type and reveal data
model <- make_model("X -> Y; X <-> Y")
type <- model \%>\% draw_causal_type()
make_data(model, parameters = type$causal_type)
}
