## Contributing to CausalQueries

:tada: Welcome to our contribution guidelines and thank you for your interest in contributing! 

  
  ### Reporting a bug
  Before you report a bug make sure the same bug hasn't been reported before. We track bugs as [issues on GitHub](https://github.com/macartan/CausalQueries/issues). 
  If no related issue has been opened, create an issue keeping in mind the following guidelines:
  
  - Use an informative title
  - Write a minimal working example that allows us to reproduce the bug you found
  - If the bug you're reporting crashes your R session, please mention that in the title
  
  ### Contributing code
  You have had a look at our [issues on GitHub](https://github.com/macartan/CausalQueries/issues) and would like to solve one of them? or you would like to develop a feature? 
  That's great and we gladly welcome that. We just would like to suggest you follow these simple guidelines:
  
  - Fork the [CausalQueries repository](https://github.com/macartan/CausalQueries) 
  - Clone your fork locally 
  - Always be up to date with the `master` branch
  - Add your edits
  - Run and pass `devtools::check()`
  - Reach a 100% coverage `covr::package_coverage()`
  - Add yourself as a contributor in the `DESCRIPTION` file
  - Open a pull request
  
  
  Note: members of the `CausalQueries` dev team can skip the first two bullet points above and branch out instead.
  
  
